/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class DecoyingModifier
extends Modifier
implements BlockBreakModifierHook,
MeleeHitModifierHook,
ProjectileHitModifierHook {
    public void spawnAnimal(Level world, Entity entity, Entity summoner) {
        world.m_7967_(entity);
        entity.m_6027_(summoner.m_20185_(), summoner.m_20186_(), summoner.m_20189_());
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.BLOCK_BREAK, ModifierHooks.MELEE_HIT, ModifierHooks.PROJECTILE_HIT);
    }

    public void spawn(Level world, Entity attacker, @Nullable Entity target) {
        int random = RANDOM.nextInt(1, 5);
        if (random == 1) {
            Cow entity = (Cow)EntityType.f_20557_.m_20615_(world);
            this.spawnAnimal(world, (Entity)entity, attacker);
        } else if (random == 2) {
            Sheep entity = (Sheep)EntityType.f_20520_.m_20615_(world);
            this.spawnAnimal(world, (Entity)entity, attacker);
        } else if (random == 3) {
            Chicken entity = (Chicken)EntityType.f_20555_.m_20615_(world);
            this.spawnAnimal(world, (Entity)entity, attacker);
        } else if (random == 4) {
            Pig entity = (Pig)EntityType.f_20510_.m_20615_(world);
            this.spawnAnimal(world, (Entity)entity, attacker);
        }
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        Level world = context.getAttacker().m_20193_();
        if (RANDOM.nextFloat() <= (float)modifier.getLevel() * 0.2f && context.isFullyCharged()) {
            this.spawn(world, (Entity)context.getAttacker(), null);
        }
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
        Level world = context.getLiving().m_20193_();
        if (RANDOM.nextFloat() <= (float)modifier.getLevel() * 0.2f && context.isEffective()) {
            this.spawn(world, (Entity)context.getLiving(), null);
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (attacker != null) {
            AbstractArrow arrow;
            Level world = attacker.m_20193_();
            if (RANDOM.nextFloat() <= (float)modifier.getLevel() * 0.2f && projectile instanceof AbstractArrow && (arrow = (AbstractArrow)projectile).m_36792_()) {
                this.spawn(world, (Entity)attacker, null);
            }
        }
        return false;
    }
}

